/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.client.PIDataBeanInterface;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.util.HscEAccess;
import com.ibm.hsc.common.util.InfoPanel;
import com.ibm.jcb.RemoteSourceException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskMessage;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.websm.bridge.WRemoteSystem;
import com.ibm.websm.bridge.WSession;
import com.ibm.websm.bridge.WSessionMgr;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EAuthorization;
import com.ibm.websm.mobject.MOXContainerObj;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Properties;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class GeneralUtil
implements Serializable {
    public static boolean debugOn = false;
    public static boolean m_isRun = true;
    public static boolean m_setRun = false;

    public static int[] getIndicesFromSelections(String[] stringArray, ItemDescriptor[] itemDescriptorArray) {
        int[] nArray = new int[stringArray.length];
        String[] stringArray2 = new String[itemDescriptorArray.length];
        for (int i = 0; i < itemDescriptorArray.length; ++i) {
            stringArray2[i] = new String(itemDescriptorArray[i].getName());
        }
        return GeneralUtil.getIndicesFromSelections(stringArray, stringArray2, false);
    }

    public static int[] getIndicesFromSelectionsEndsWith(String[] stringArray, ItemDescriptor[] itemDescriptorArray) {
        int[] nArray = new int[stringArray.length];
        String[] stringArray2 = new String[itemDescriptorArray.length];
        for (int i = 0; i < itemDescriptorArray.length; ++i) {
            stringArray2[i] = new String(itemDescriptorArray[i].getName());
        }
        return GeneralUtil.getIndicesFromSelections(stringArray, stringArray2, true);
    }

    public static int[] getIndicesFromSelections(String[] stringArray, String[] stringArray2) {
        int[] nArray = new int[stringArray.length];
        block0: for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = -1;
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray2[j].equals(stringArray[i])) continue;
                nArray[i] = j;
                continue block0;
            }
        }
        return nArray;
    }

    public static int[] getIndicesFromSelections(String[] stringArray, String[] stringArray2, boolean bl) {
        int[] nArray = new int[stringArray.length];
        block0: for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = -1;
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray2[j].equals(stringArray[i]) && (!bl || !stringArray[i].endsWith(stringArray2[j]))) continue;
                nArray[i] = j;
                continue block0;
            }
        }
        return nArray;
    }

    public static String getTimeFormatted(String string) {
        try {
            short s = (short)Integer.parseInt(string);
            short s2 = (short)(s / 24);
            short s3 = (short)(s % 24);
            String string2 = HSCResourceBundleUtil.getMessage("CECBundle", "DAYS", "dy(s)");
            String string3 = HSCResourceBundleUtil.getMessage("CECBundle", "HOURS", "hr(s)");
            string = s2 + " " + string2 + "/" + s3 + " " + string3;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static void handleException(Throwable throwable, String string, String string2) {
        block9: {
            try {
                Throwable throwable2;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                throwable.printStackTrace(printStream);
                String string3 = null;
                if (IDebug.enabled) {
                    System.out.println("check remote source exception");
                }
                if (throwable instanceof RemoteSourceException && (throwable = (throwable2 = (RemoteSourceException)throwable).getSourceException()) instanceof InvocationTargetException) {
                    InvocationTargetException invocationTargetException = (InvocationTargetException)throwable;
                    if (IDebug.enabled) {
                        System.out.println("calling get target exception");
                    }
                    throwable = invocationTargetException.getTargetException();
                }
                if (throwable instanceof HSCException) {
                    if (IDebug.enabled) {
                        System.out.println("get HSCRMCException");
                    }
                    throwable2 = (HSCException)throwable;
                    string3 = ((HSCException)throwable2).getMessage();
                }
                if (string3 == null) {
                    string3 = string2;
                }
                new InfoPanel(string3, string, null).show();
                printStream.close();
                byteArrayOutputStream.close();
                if (IDebug.enabled) {
                    throwable.printStackTrace(System.out);
                }
            }
            catch (IOException iOException) {
                if (!IDebug.enabled) break block9;
                iOException.printStackTrace(System.out);
            }
        }
    }

    public static int getIntValue(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static String checkValue(int n, int n2, int n3, int n4) {
        int n5 = n % n4;
        String string = null;
        if (n5 != 0) {
            string = MessageFormat.format(HSCResourceBundleUtil.getMessage("LPARBundle", "MUST_BE_MULTIPLE", "Must be multiple of {0}"), new Integer(256));
        } else if (n5 < n2) {
            string = MessageFormat.format(HSCResourceBundleUtil.getMessage("LPARBundle", "MUST_BE_GREATER_THAN", "Must be greater than {0}"), new Integer(n2));
        } else if (n5 > n3) {
            string = MessageFormat.format(HSCResourceBundleUtil.getMessage("LPARBundle", "MUST_BE_LESS_THAN", "Must be less than {0}"), new Integer(n3));
        }
        return string;
    }

    public static String getStringFromMethod(PIDataBeanInterface pIDataBeanInterface, String string) throws Exception {
        Method method = pIDataBeanInterface.getClass().getMethod(string, null);
        Object object = method.invoke((Object)pIDataBeanInterface, null);
        GeneralUtil.debug(" Method Name " + string);
        GeneralUtil.debug(" Value  " + object);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof UnsignedInt32) {
            return ((UnsignedInt32)object).toString();
        }
        if (object instanceof UnsignedInt16) {
            return ((UnsignedInt16)object).toString();
        }
        if (object instanceof UnsignedInt8) {
            return ((UnsignedInt8)object).toString();
        }
        return "";
    }

    public static String[] getStringArrayFromMethod(PIDataBeanInterface pIDataBeanInterface, String string) throws Exception {
        Method method = pIDataBeanInterface.getClass().getMethod(string, null);
        Object object = method.invoke((Object)pIDataBeanInterface, null);
        GeneralUtil.debug(" Method Name " + string);
        GeneralUtil.debug(" Value  " + object);
        if (object instanceof String[]) {
            return (String[])object;
        }
        if (object instanceof UnsignedInt32[]) {
            UnsignedInt32[] unsignedInt32Array = (UnsignedInt32[])object;
            String[] stringArray = new String[unsignedInt32Array.length];
            for (int i = 0; i < unsignedInt32Array.length; ++i) {
                stringArray[i] = unsignedInt32Array[i].toString();
            }
            return stringArray;
        }
        if (object instanceof UnsignedInt16[]) {
            UnsignedInt16[] unsignedInt16Array = (UnsignedInt16[])object;
            String[] stringArray = new String[unsignedInt16Array.length];
            for (int i = 0; i < unsignedInt16Array.length; ++i) {
                stringArray[i] = unsignedInt16Array[i].toString();
            }
            return stringArray;
        }
        if (object instanceof UnsignedInt8[]) {
            UnsignedInt8[] unsignedInt8Array = (UnsignedInt8[])object;
            String[] stringArray = new String[unsignedInt8Array.length];
            for (int i = 0; i < unsignedInt8Array.length; ++i) {
                stringArray[i] = unsignedInt8Array[i].toString();
            }
            return stringArray;
        }
        return null;
    }

    public static int getIntFromMethod(PIDataBeanInterface pIDataBeanInterface, String string) throws Exception {
        Method method = pIDataBeanInterface.getClass().getMethod(string, null);
        Object object = method.invoke((Object)pIDataBeanInterface, null);
        GeneralUtil.debug(" Method Name " + string);
        GeneralUtil.debug(" Value  " + object);
        if (object instanceof String) {
            return GeneralUtil.getIntValue((String)object);
        }
        if (object instanceof UnsignedInt32) {
            return ((UnsignedInt32)object).intValue();
        }
        if (object instanceof UnsignedInt16) {
            return ((UnsignedInt16)object).intValue();
        }
        if (object instanceof UnsignedInt8) {
            return ((UnsignedInt8)object).intValue();
        }
        return -1;
    }

    public static String convertOnOffState(byte by) {
        GeneralUtil.debug("On/Off STATE is " + by);
        if (by == 0) {
            return GeneralUtil.getMessage("AVAILABLE");
        }
        if (by == 1) {
            return GeneralUtil.getMessage("CEC_STATE_NOT_AVAILABLE");
        }
        if (by == 2) {
            return GeneralUtil.getMessage("CEC_RUNNING");
        }
        if (by == 3) {
            return GeneralUtil.getMessage("COD_STATE_UNRETURNED");
        }
        if (by == 4) {
            return GeneralUtil.getMessage("COD_STATE_NOT_ENABLED");
        }
        return " ";
    }

    public static String convertReserveState(byte by) {
        GeneralUtil.debug("Reserve STATE is " + by);
        if (by == 0) {
            return GeneralUtil.getMessage("AVAILABLE");
        }
        if (by == 1) {
            return GeneralUtil.getMessage("CEC_STATE_NOT_AVAILABLE");
        }
        if (by == 2) {
            return GeneralUtil.getMessage("CEC_RUNNING");
        }
        if (by == 3) {
            return GeneralUtil.getMessage("COD_STATE_NOT_ENABLED");
        }
        return " ";
    }

    public static String convertTrialState(byte by) {
        GeneralUtil.debug("Trial STATE is " + by);
        if (by == 0) {
            return GeneralUtil.getMessage("CEC_RUNNING");
        }
        if (by == 1) {
            return GeneralUtil.getMessage("COD_STATE_NOT_RUNNING");
        }
        if (by == 2) {
            return GeneralUtil.getMessage("COD_STATE_UNRETURNED");
        }
        return " ";
    }

    private static void debug(String string) {
        if (IDebug.enabled || debugOn) {
            System.err.println("-------> " + string);
        }
    }

    private static String getMessage(String string) {
        return HSCResourceBundleUtil.getMessage("CECBundle", string);
    }

    public static String removePercentSign(String string) {
        int n = string.indexOf(37);
        String string2 = string;
        if (n >= 0) {
            string2 = string.substring(0, n) + string.substring(n + 1);
        }
        return string2;
    }

    public static void setAuimlSizeProperties(String string, Properties properties) {
        if (IDebug.enabled) {
            System.err.println("Setting PERSISTBOUNDS for " + string);
        }
        properties.put(string, "PERSISTBOUNDS:FALSE");
        properties.put(string, "SCROLL:FALSE");
    }

    public static boolean canModify(MOXContainerObj mOXContainerObj) {
        String string = GeneralUtil.getRole(mOXContainerObj);
        return string.equals("hmcsuperadmin");
    }

    public static String getUser(MOXContainerObj mOXContainerObj) {
        block3: {
            try {
                WSession wSession = WSessionMgr.getSessionMgr().getSession(mOXContainerObj.getMOClass().getHost().getName());
                if (wSession != null) {
                    WRemoteSystem wRemoteSystem = wSession.getRemoteSystem();
                    EAuthorization eAuthorization = wRemoteSystem.getAuthorization();
                    String string = eAuthorization.getName();
                    return string;
                }
            }
            catch (Exception exception) {
                if (!IDebug.enabled) break block3;
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static String getRole(MOXContainerObj mOXContainerObj) {
        try {
            String string = HscEAccess.getRoleName(mOXContainerObj.getMOClass().getHost().getName());
            return string;
        }
        catch (Exception exception) {
            if (IDebug.enabled) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    public static boolean runMethod() {
        if (m_setRun) {
            return m_isRun;
        }
        m_setRun = true;
        try {
            String string = System.getProperty("DontRunMethod");
            if (string.equals("True")) {
                m_isRun = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return m_isRun;
    }

    public static void showExceptionMessage(String string, Throwable throwable, UserTaskManager userTaskManager) {
        Throwable throwable2;
        String string2 = null;
        if (throwable instanceof RemoteSourceException && (throwable2 = ((RemoteSourceException)throwable).getSourceException()) != null) {
            if (throwable2.getMessage() != null) {
                string2 = throwable2.getMessage();
                new TaskMessage(userTaskManager, string2, string, 1, null, null).invoke();
            } else if (IDebug.enabled) {
                System.err.println("Unable to get information from the exception");
            }
        }
    }

    public static String getLparIntName(String string) {
        GeneralUtil.debug("getLparIntName ->" + string);
        if (string.indexOf("~") >= 0) {
            return string.substring(0, string.indexOf("~"));
        }
        return string;
    }

    public static String getLparKeyFromProfKey(String string) {
        GeneralUtil.debug("getLparKeyFromProfKey ->" + string);
        String string2 = string;
        int n = string2.lastIndexOf(126);
        if (n >= 0 && (n = (string2 = string2.substring(0, n)).lastIndexOf(126)) >= 0) {
            string2 = string2.substring(0, n + 1);
        }
        GeneralUtil.debug("getLparKeyFromProfKey-> returnging " + string2);
        return string2;
    }

    public static String getCecIntName(String string) {
        GeneralUtil.debug("getCecIntName : " + string);
        String string2 = GeneralUtil.getLparIntName(string);
        GeneralUtil.debug("lparIntName = " + string2);
        int n = string2.indexOf("*");
        String string3 = string2.substring(n + 1);
        GeneralUtil.debug("cecIntName = " + string3);
        return string3;
    }

    public static boolean isPerfPropertySet() {
        try {
            String string = System.getProperty("RunWithLPARPerfFix");
            if (string == null) {
                return false;
            }
            if (string.equalsIgnoreCase("true")) {
                return true;
            }
        }
        catch (Throwable throwable) {
            if (IDebug.enabled) {
                throwable.printStackTrace();
            }
            GeneralUtil.debug(throwable.getMessage());
        }
        return false;
    }
}

